/* --------------------------------------------------------------
  AppFrame.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Application Frame Class
 *
 * This class will initialize the main StyleEdit frame, mainly the common components that
 * are shared through every view of the execution lifecycle.
 */
export default class AppFrame {
	/**
	 * Class Constructor 
	 * 
	 * @param {jQuery} $target
	 * @param {PreviewResizer} previewResizer
	 * @param {FrameToggle} frameToggle
	 */
	constructor($target, previewResizer, frameToggle) {
		StyleEdit.Validator.isObject($target);
		StyleEdit.Validator.isObject(previewResizer);
		StyleEdit.Validator.isObject(frameToggle);
		
		/**
		 * Application Frame Selector
		 *
		 * @type {jQuery}
		 */
		this.$target = $target;
		
		/**
		 * Preview Resizer Instance
		 *
		 * @type {PreviewResizer}
		 */
		this.previewResizer = previewResizer;
		
		/**
		 * Frame Toggle Instance
		 *
		 * @type {FrameToggle}
		 */
		this.frameToggle = frameToggle;
	}
	
	/**
	 * Initialize the instance.
	 *
	 * This method will bind the required event handlers and setup the respective template
	 * for the app frame.
	 */
	initialize() {
		this.frameToggle.initialize();
		this.previewResizer.initialize();
	}
}